/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.statistics.plugin;

import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.gephi.data.attributes.api.AttributeColumn;
import org.gephi.data.attributes.api.AttributeModel;
import org.gephi.data.attributes.api.AttributeOrigin;
import org.gephi.data.attributes.api.AttributeRow;
import org.gephi.data.attributes.api.AttributeTable;
import org.gephi.data.attributes.api.AttributeType;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.EdgeIterable;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.HierarchicalDirectedGraph;
import org.gephi.graph.api.HierarchicalGraph;
import org.gephi.graph.api.Node;
import org.gephi.statistics.spi.Statistics;
import org.gephi.utils.TempDirUtils;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.StandardEntityCollection;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.openide.util.Lookup;

public class EigenvectorCentrality
implements Statistics,
LongTask {
    public static final String EIGENVECTOR = "eigencentrality";
    private int numRuns = 100;
    private double[] centralities;
    private double sumChange;
    private ProgressTicket progress;
    private boolean isCanceled;
    private boolean isDirected;

    public EigenvectorCentrality() {
        GraphController graphController = (GraphController)Lookup.getDefault().lookup(GraphController.class);
        if (graphController != null && graphController.getModel() != null) {
            this.isDirected = graphController.getModel().isDirected();
        }
    }

    public void setNumRuns(int numRuns) {
        this.numRuns = numRuns;
    }

    public int getNumRuns() {
        return this.numRuns;
    }

    public boolean isDirected() {
        return this.isDirected;
    }

    public void setDirected(boolean isDirected) {
        this.isDirected = isDirected;
    }

    public void execute(GraphModel graphModel, AttributeModel attributeModel) {
        HierarchicalGraph graph = null;
        graph = this.isDirected ? graphModel.getHierarchicalDirectedGraphVisible() : graphModel.getHierarchicalUndirectedGraphVisible();
        this.execute(graph, attributeModel);
    }

    public void execute(HierarchicalGraph hgraph, AttributeModel attributeModel) {
        AttributeTable nodeTable = attributeModel.getNodeTable();
        AttributeColumn eigenCol = nodeTable.getColumn(EIGENVECTOR);
        if (eigenCol == null) {
            eigenCol = nodeTable.addColumn(EIGENVECTOR, "Eigenvector Centrality", AttributeType.DOUBLE, AttributeOrigin.COMPUTED, (Object)new Double(0.0));
        }
        int N = hgraph.getNodeCount();
        hgraph.readLock();
        double[] tmp = new double[N];
        this.centralities = new double[N];
        Progress.start(this.progress, this.numRuns);
        HashMap<Integer, Node> indicies = new HashMap<Integer, Node>();
        HashMap<Node, Integer> invIndicies = new HashMap<Node, Integer>();
        int count = 0;
        for (Node u : hgraph.getNodes()) {
            indicies.put(count, u);
            invIndicies.put(u, count);
            this.centralities[count] = 1.0;
            ++count;
        }
        for (int s = 0; s < this.numRuns; ++s) {
            double max = 0.0;
            for (int i = 0; i < N; ++i) {
                Node u = (Node)indicies.get(i);
                EdgeIterable iter = null;
                iter = this.isDirected ? ((HierarchicalDirectedGraph)hgraph).getInEdgesAndMetaInEdges(u) : hgraph.getEdges(u);
                for (Edge e : iter) {
                    Node v = hgraph.getOpposite(u, e);
                    Integer id = (Integer)invIndicies.get(v);
                    int n = i;
                    tmp[n] = tmp[n] + this.centralities[id];
                }
                max = Math.max(max, tmp[i]);
                if (!this.isCanceled) continue;
                return;
            }
            this.sumChange = 0.0;
            for (int k = 0; k < N; ++k) {
                if (max != 0.0) {
                    this.sumChange += Math.abs(this.centralities[k] - tmp[k] / max);
                    this.centralities[k] = tmp[k] / max;
                }
                if (!this.isCanceled) continue;
                return;
            }
            if (this.isCanceled) {
                return;
            }
            Progress.progress(this.progress);
        }
        for (int i = 0; i < N; ++i) {
            Node s = (Node)indicies.get(i);
            AttributeRow row = (AttributeRow)s.getNodeData().getAttributes();
            row.setValue(eigenCol, (Object)this.centralities[i]);
            if (!this.isCanceled) continue;
            return;
        }
        hgraph.readUnlock();
        Progress.finish(this.progress);
    }

    public String getReport() {
        XYSeries series = new XYSeries((Comparable)((Object)"Series 2"));
        for (int i = 0; i < this.centralities.length; ++i) {
            series.add((double)i, this.centralities[i]);
        }
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(series);
        JFreeChart chart = ChartFactory.createXYLineChart((String)"Eigenvector Centralities", (String)"Nodes", (String)"Eigenvector Centrality", (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        XYPlot plot = (XYPlot)chart.getPlot();
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
        renderer.setSeriesLinesVisible(0, true);
        renderer.setSeriesShapesVisible(0, false);
        renderer.setSeriesLinesVisible(1, false);
        renderer.setSeriesShapesVisible(1, true);
        renderer.setSeriesShape(1, (Shape)new Ellipse2D.Double(0.0, 0.0, 1.0, 1.0));
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setDomainGridlinePaint((Paint)Color.GRAY);
        plot.setRangeGridlinePaint((Paint)Color.GRAY);
        plot.setRenderer((XYItemRenderer)renderer);
        String imageFile = "";
        try {
            ChartRenderingInfo info = new ChartRenderingInfo((EntityCollection)new StandardEntityCollection());
            TempDirUtils.TempDir tempDir = TempDirUtils.createTempDir();
            String fileName = "eigen.png";
            File file1 = tempDir.createFile(fileName);
            imageFile = "<IMG SRC=\"file:" + file1.getAbsolutePath() + "\" " + "WIDTH=\"600\" HEIGHT=\"400\" BORDER=\"0\" USEMAP=\"#chart\"></IMG>";
            ChartUtilities.saveChartAsPNG((File)file1, (JFreeChart)chart, (int)600, (int)400, (ChartRenderingInfo)info);
        }
        catch (IOException e) {
            System.out.println(e.toString());
        }
        String report = "<HTML> <BODY> <h1>Eigenvector Centrality Report</h1> <hr><h2> Parameters: </h2>Network Interpretation:  " + (this.isDirected ? "directed" : "undirected") + "<br>" + "Number of iterations: " + this.numRuns + "<br>" + "Sum change: " + this.sumChange + "<br> <h2> Results: </h2>" + imageFile + "</BODY></HTML>";
        return report;
    }

    public boolean cancel() {
        this.isCanceled = true;
        return true;
    }

    public void setProgressTicket(ProgressTicket progressTicket) {
        this.progress = progressTicket;
    }
}

