/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.statistics.plugin;

import org.gephi.data.attributes.api.AttributeModel;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.HierarchicalGraph;
import org.gephi.statistics.spi.Statistics;
import org.openide.util.Lookup;

public class GraphDensity
implements Statistics {
    private double density;
    private boolean isDirected;

    public GraphDensity() {
        GraphController graphController = (GraphController)Lookup.getDefault().lookup(GraphController.class);
        if (graphController != null && graphController.getModel() != null) {
            this.isDirected = graphController.getModel().isDirected();
        }
    }

    public void setDirected(boolean isDirected) {
        this.isDirected = isDirected;
    }

    public boolean getDirected() {
        return this.isDirected;
    }

    public double getDensity() {
        return this.density;
    }

    public void execute(GraphModel graphModel, AttributeModel attributeModel) {
        HierarchicalGraph hgraph = this.isDirected ? graphModel.getHierarchicalDirectedGraphVisible() : graphModel.getHierarchicalUndirectedGraphVisible();
        double edgesCount = hgraph.getTotalEdgeCount();
        double nodesCount = hgraph.getNodeCount();
        double multiplier = 1.0;
        if (!this.isDirected) {
            multiplier = 2.0;
        }
        this.density = multiplier * edgesCount / (nodesCount * nodesCount - nodesCount);
    }

    public String getReport() {
        return "<HTML> <BODY> <h1>Graph Density  Report </h1> <hr><br><h2> Parameters: </h2>Network Interpretation:  " + (this.isDirected ? "directed" : "undirected") + "<br>" + "<br> <h2> Results: </h2>" + "Density: " + this.density + "</BODY></HTML>";
    }
}

