/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.statistics.plugin;

import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Stack;
import org.gephi.data.attributes.api.AttributeColumn;
import org.gephi.data.attributes.api.AttributeModel;
import org.gephi.data.attributes.api.AttributeOrigin;
import org.gephi.data.attributes.api.AttributeRow;
import org.gephi.data.attributes.api.AttributeTable;
import org.gephi.data.attributes.api.AttributeType;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.EdgeIterable;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.HierarchicalDirectedGraph;
import org.gephi.graph.api.HierarchicalGraph;
import org.gephi.graph.api.Node;
import org.gephi.statistics.spi.Statistics;
import org.gephi.utils.TempDirUtils;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.StandardEntityCollection;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class GraphDistance
implements Statistics,
LongTask {
    public static final String BETWEENNESS = "betweenesscentrality";
    public static final String CLOSENESS = "closnesscentrality";
    public static final String ECCENTRICITY = "eccentricity";
    private double[] betweenness;
    private double[] closeness;
    private double[] eccentricity;
    private int diameter;
    private int radius;
    private double avgDist;
    private int N;
    private boolean isDirected;
    private ProgressTicket progress;
    private boolean isCanceled;
    private int shortestPaths;
    private boolean isRelativeValues;

    public GraphDistance() {
        GraphController graphController = (GraphController)Lookup.getDefault().lookup(GraphController.class);
        if (graphController != null && graphController.getModel() != null) {
            this.isDirected = graphController.getModel().isDirected();
        }
    }

    public double getPathLength() {
        return this.avgDist;
    }

    public double getDiameter() {
        return this.diameter;
    }

    public void execute(GraphModel graphModel, AttributeModel attributeModel) {
        HierarchicalGraph graph = null;
        graph = this.isDirected ? graphModel.getHierarchicalDirectedGraphVisible() : graphModel.getHierarchicalUndirectedGraphVisible();
        this.execute(graph, attributeModel);
    }

    public void execute(HierarchicalGraph hgraph, AttributeModel attributeModel) {
        this.isCanceled = false;
        AttributeTable nodeTable = attributeModel.getNodeTable();
        AttributeColumn eccentricityCol = nodeTable.getColumn(ECCENTRICITY);
        AttributeColumn closenessCol = nodeTable.getColumn(CLOSENESS);
        AttributeColumn betweenessCol = nodeTable.getColumn(BETWEENNESS);
        if (eccentricityCol == null) {
            eccentricityCol = nodeTable.addColumn(ECCENTRICITY, "Eccentricity", AttributeType.DOUBLE, AttributeOrigin.COMPUTED, (Object)new Double(0.0));
        }
        if (closenessCol == null) {
            closenessCol = nodeTable.addColumn(CLOSENESS, "Closeness Centrality", AttributeType.DOUBLE, AttributeOrigin.COMPUTED, (Object)new Double(0.0));
        }
        if (betweenessCol == null) {
            betweenessCol = nodeTable.addColumn(BETWEENNESS, "Betweenness Centrality", AttributeType.DOUBLE, AttributeOrigin.COMPUTED, (Object)new Double(0.0));
        }
        hgraph.readLock();
        this.N = hgraph.getNodeCount();
        this.betweenness = new double[this.N];
        this.eccentricity = new double[this.N];
        this.closeness = new double[this.N];
        this.diameter = 0;
        this.avgDist = 0.0;
        this.shortestPaths = 0;
        this.radius = Integer.MAX_VALUE;
        HashMap<Node, Integer> indicies = new HashMap<Node, Integer>();
        int index = 0;
        for (Node s : hgraph.getNodes()) {
            indicies.put(s, index);
            ++index;
        }
        Progress.start(this.progress, hgraph.getNodeCount());
        int count = 0;
        for (Node s : hgraph.getNodes()) {
            Stack<Node> S = new Stack<Node>();
            LinkedList[] P = new LinkedList[this.N];
            double[] theta = new double[this.N];
            int[] d = new int[this.N];
            for (int j = 0; j < this.N; ++j) {
                P[j] = new LinkedList();
                theta[j] = 0.0;
                d[j] = -1;
            }
            int s_index = (Integer)indicies.get(s);
            theta[s_index] = 1.0;
            d[s_index] = 0;
            LinkedList<Node> Q = new LinkedList<Node>();
            Q.addLast(s);
            while (!Q.isEmpty()) {
                Node v = (Node)Q.removeFirst();
                S.push(v);
                int v_index = (Integer)indicies.get(v);
                EdgeIterable edgeIter = null;
                edgeIter = this.isDirected ? ((HierarchicalDirectedGraph)hgraph).getOutEdgesAndMetaOutEdges(v) : hgraph.getEdgesAndMetaEdges(v);
                for (Edge edge : edgeIter) {
                    Node reachable = hgraph.getOpposite(v, edge);
                    int r_index = (Integer)indicies.get(reachable);
                    if (d[r_index] < 0) {
                        Q.addLast(reachable);
                        d[r_index] = d[v_index] + 1;
                    }
                    if (d[r_index] != d[v_index] + 1) continue;
                    theta[r_index] = theta[r_index] + theta[v_index];
                    P[r_index].addLast(v);
                }
            }
            double reachable = 0.0;
            for (int i = 0; i < this.N; ++i) {
                if (d[i] <= 0) continue;
                this.avgDist += (double)d[i];
                this.eccentricity[s_index] = (int)Math.max(this.eccentricity[s_index], (double)d[i]);
                int n = s_index;
                this.closeness[n] = this.closeness[n] + (double)d[i];
                this.diameter = Math.max(this.diameter, d[i]);
                reachable += 1.0;
            }
            this.radius = (int)Math.min(this.eccentricity[s_index], (double)this.radius);
            if (reachable != 0.0) {
                int n = s_index;
                this.closeness[n] = this.closeness[n] / reachable;
            }
            this.shortestPaths = (int)((double)this.shortestPaths + reachable);
            double[] delta = new double[this.N];
            while (!S.empty()) {
                Node w = (Node)S.pop();
                int w_index = (Integer)indicies.get(w);
                ListIterator iter1 = P[w_index].listIterator();
                while (iter1.hasNext()) {
                    int u_index;
                    Node u = (Node)iter1.next();
                    int n = u_index = ((Integer)indicies.get(u)).intValue();
                    delta[n] = delta[n] + theta[u_index] / theta[w_index] * (1.0 + delta[w_index]);
                }
                if (w == s) continue;
                int n = w_index;
                this.betweenness[n] = this.betweenness[n] + delta[w_index];
            }
            ++count;
            if (this.isCanceled) {
                hgraph.readUnlockAll();
                return;
            }
            Progress.progress(this.progress, count);
        }
        this.avgDist /= (double)this.shortestPaths;
        for (Node s : hgraph.getNodes()) {
            AttributeRow row = (AttributeRow)s.getNodeData().getAttributes();
            int s_index = (Integer)indicies.get(s);
            if (!this.isDirected) {
                int n = s_index;
                this.betweenness[n] = this.betweenness[n] / 2.0;
            }
            if (this.isRelativeValues) {
                this.closeness[s_index] = this.closeness[s_index] == 0.0 ? 0.0 : 1.0 / this.closeness[s_index];
                int n = s_index;
                this.betweenness[n] = this.betweenness[n] / (this.isDirected ? (double)((this.N - 1) * (this.N - 2)) : (double)((this.N - 1) * (this.N - 2) / 2));
            }
            row.setValue(eccentricityCol, (Object)this.eccentricity[s_index]);
            row.setValue(closenessCol, (Object)this.closeness[s_index]);
            row.setValue(betweenessCol, (Object)this.betweenness[s_index]);
        }
        hgraph.readUnlock();
    }

    public void setRelative(boolean isRelative) {
        this.isRelativeValues = isRelative;
    }

    public boolean useRelative() {
        return this.isRelativeValues;
    }

    public void setDirected(boolean isDirected) {
        this.isDirected = isDirected;
    }

    public boolean isDirected() {
        return this.isDirected;
    }

    private String createImageFile(TempDirUtils.TempDir tempDir, double[] pVals, String pName, String pX, String pY) throws IOException {
        XYSeries series = new XYSeries((Comparable)((Object)pName));
        for (int i = 0; i < this.N; ++i) {
            series.add((double)i, pVals[i]);
        }
        XYSeriesCollection dataSet = new XYSeriesCollection();
        dataSet.addSeries(series);
        JFreeChart chart = ChartFactory.createXYLineChart((String)pName, (String)pX, (String)pY, (XYDataset)dataSet, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        XYPlot plot = (XYPlot)chart.getPlot();
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
        renderer.setSeriesLinesVisible(0, false);
        renderer.setSeriesShapesVisible(0, true);
        renderer.setSeriesShape(0, (Shape)new Ellipse2D.Double(0.0, 0.0, 1.0, 1.0));
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setDomainGridlinePaint((Paint)Color.GRAY);
        plot.setRangeGridlinePaint((Paint)Color.GRAY);
        plot.setRenderer((XYItemRenderer)renderer);
        String imageFile = "";
        ChartRenderingInfo info = new ChartRenderingInfo((EntityCollection)new StandardEntityCollection());
        String fileName = pY + ".png";
        File file1 = tempDir.createFile(fileName);
        imageFile = "<IMG SRC=\"file:" + file1.getAbsolutePath() + "\" " + "WIDTH=\"600\" HEIGHT=\"400\" BORDER=\"0\" USEMAP=\"#chart\"></IMG>";
        ChartUtilities.saveChartAsPNG((File)file1, (JFreeChart)chart, (int)600, (int)400, (ChartRenderingInfo)info);
        return imageFile;
    }

    public String getReport() {
        String htmlIMG1 = "";
        String htmlIMG2 = "";
        String htmlIMG3 = "";
        try {
            TempDirUtils.TempDir tempDir = TempDirUtils.createTempDir();
            htmlIMG1 = this.createImageFile(tempDir, this.betweenness, "Betweenness Centrality", "Nodes", "Betweenness");
            htmlIMG2 = this.createImageFile(tempDir, this.closeness, "Closeness Centrality", "Nodes", "Closeness");
            htmlIMG3 = this.createImageFile(tempDir, this.eccentricity, "Eccentricity", "Nodes", "Eccentricity");
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        String report = "<HTML> <BODY> <h1>Graph Distance  Report </h1> <hr><br><h2> Parameters: </h2>Network Interpretation:  " + (this.isDirected ? "directed" : "undirected") + "<br>" + "<br> <h2> Results: </h2>" + "Diameter: " + this.diameter + "<br>" + "Radius: " + this.radius + "<br>" + "Average Path length: " + this.avgDist + "<br>" + "Number of shortest paths: " + this.shortestPaths + "<br>" + htmlIMG1 + "<br>" + htmlIMG2 + "<br>" + htmlIMG3 + "</BODY></HTML>";
        return report;
    }

    public boolean cancel() {
        this.isCanceled = true;
        return true;
    }

    public void setProgressTicket(ProgressTicket progressTicket) {
        this.progress = progressTicket;
    }
}

