/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.statistics.plugin;

import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import org.gephi.data.attributes.api.AttributeColumn;
import org.gephi.data.attributes.api.AttributeModel;
import org.gephi.data.attributes.api.AttributeOrigin;
import org.gephi.data.attributes.api.AttributeRow;
import org.gephi.data.attributes.api.AttributeTable;
import org.gephi.data.attributes.api.AttributeType;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.EdgeIterable;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.HierarchicalDirectedGraph;
import org.gephi.graph.api.HierarchicalGraph;
import org.gephi.graph.api.HierarchicalUndirectedGraph;
import org.gephi.graph.api.Node;
import org.gephi.statistics.spi.Statistics;
import org.gephi.utils.TempDirUtils;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.StandardEntityCollection;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class Hits
implements Statistics,
LongTask {
    public static final String AUTHORITY = "authority";
    public static final String HUB = "hub";
    private boolean isCanceled;
    private ProgressTicket progress;
    private double[] authority;
    private double[] hubs;
    private boolean useUndirected;
    private double epsilon = 1.0E-4;
    private LinkedList<Node> hub_list;
    private LinkedList<Node> auth_list;
    private HashMap<Node, Integer> indicies;

    public Hits() {
        GraphController graphController = (GraphController)Lookup.getDefault().lookup(GraphController.class);
        if (graphController != null && graphController.getModel() != null) {
            this.useUndirected = graphController.getModel().isUndirected();
        }
    }

    public void setUndirected(boolean pUndirected) {
        this.useUndirected = pUndirected;
    }

    public boolean getUndirected() {
        return this.useUndirected;
    }

    public void execute(GraphModel graphModel, AttributeModel attributeModel) {
        HierarchicalGraph graph = null;
        graph = this.useUndirected ? graphModel.getHierarchicalUndirectedGraphVisible() : graphModel.getHierarchicalDirectedGraphVisible();
        this.execute(graph, attributeModel);
    }

    public void execute(HierarchicalGraph hgraph, AttributeModel attributeModel) {
        boolean done;
        int n_index;
        hgraph.readLock();
        int N = hgraph.getNodeCount();
        this.authority = new double[N];
        this.hubs = new double[N];
        double[] temp_authority = new double[N];
        double[] temp_hubs = new double[N];
        this.hub_list = new LinkedList();
        this.auth_list = new LinkedList();
        Progress.start(this.progress);
        this.indicies = new HashMap();
        int index = 0;
        for (Node node : hgraph.getNodes()) {
            this.indicies.put(node, new Integer(index));
            ++index;
            if (!this.useUndirected) {
                if (((HierarchicalDirectedGraph)hgraph).getTotalOutDegree(node) > 0) {
                    this.hub_list.add(node);
                }
                if (((HierarchicalDirectedGraph)hgraph).getTotalInDegree(node) <= 0) continue;
                this.auth_list.add(node);
                continue;
            }
            if (((HierarchicalUndirectedGraph)hgraph).getTotalDegree(node) <= 0) continue;
            this.hub_list.add(node);
            this.auth_list.add(node);
        }
        for (Node node : this.hub_list) {
            n_index = this.indicies.get(node);
            this.hubs[n_index] = 1.0;
        }
        for (Node node : this.auth_list) {
            n_index = this.indicies.get(node);
            this.authority[n_index] = 1.0;
        }
        do {
            done = true;
            double auth_sum = 0.0;
            for (Node node : this.auth_list) {
                int n_index2 = this.indicies.get(node);
                temp_authority[n_index2] = this.authority[n_index2];
                EdgeIterable edge_iter = !this.useUndirected ? ((HierarchicalDirectedGraph)hgraph).getInEdgesAndMetaInEdges(node) : ((HierarchicalUndirectedGraph)hgraph).getEdgesAndMetaEdges(node);
                for (Edge edge : edge_iter) {
                    Node target = hgraph.getOpposite(node, edge);
                    int target_index = this.indicies.get(target);
                    int n = n_index2;
                    temp_authority[n] = temp_authority[n] + this.hubs[target_index];
                }
                auth_sum += temp_authority[n_index2];
                if (!this.isCanceled) continue;
                break;
            }
            double hub_sum = 0.0;
            for (Node node : this.hub_list) {
                int n_index3 = this.indicies.get(node);
                temp_hubs[n_index3] = this.hubs[n_index3];
                EdgeIterable edge_iter = !this.useUndirected ? ((HierarchicalDirectedGraph)hgraph).getInEdgesAndMetaInEdges(node) : ((HierarchicalUndirectedGraph)hgraph).getEdgesAndMetaEdges(node);
                for (Edge edge : edge_iter) {
                    Node target = hgraph.getOpposite(node, edge);
                    int target_index = this.indicies.get(target);
                    int n = n_index3;
                    temp_hubs[n] = temp_hubs[n] + this.authority[target_index];
                }
                hub_sum += temp_hubs[n_index3];
                if (!this.isCanceled) continue;
                break;
            }
            for (Node node : this.auth_list) {
                int n_index4;
                int n = n_index4 = this.indicies.get(node).intValue();
                temp_authority[n] = temp_authority[n] / auth_sum;
                if (!((temp_authority[n_index4] - this.authority[n_index4]) / this.authority[n_index4] >= this.epsilon)) continue;
                done = false;
            }
            for (Node node : this.hub_list) {
                int n_index5;
                int n = n_index5 = this.indicies.get(node).intValue();
                temp_hubs[n] = temp_hubs[n] / hub_sum;
                if (!((temp_hubs[n_index5] - this.hubs[n_index5]) / this.hubs[n_index5] >= this.epsilon)) continue;
                done = false;
            }
            this.authority = temp_authority;
            this.hubs = temp_hubs;
            temp_authority = new double[N];
            temp_hubs = new double[N];
        } while (!done && !this.isCanceled);
        AttributeTable nodeTable = attributeModel.getNodeTable();
        AttributeColumn authorityCol = nodeTable.getColumn(AUTHORITY);
        AttributeColumn hubsCol = nodeTable.getColumn(HUB);
        if (authorityCol == null) {
            authorityCol = nodeTable.addColumn(AUTHORITY, "Authority", AttributeType.FLOAT, AttributeOrigin.COMPUTED, (Object)new Float(0.0f));
        }
        if (hubsCol == null) {
            hubsCol = nodeTable.addColumn(HUB, "Hub", AttributeType.FLOAT, AttributeOrigin.COMPUTED, (Object)new Float(0.0f));
        }
        for (Node s : hgraph.getNodes()) {
            int s_index = this.indicies.get(s);
            AttributeRow row = (AttributeRow)s.getNodeData().getAttributes();
            row.setValue(authorityCol, (Object)Float.valueOf((float)this.authority[s_index]));
            row.setValue(hubsCol, (Object)Float.valueOf((float)this.hubs[s_index]));
        }
        hgraph.readUnlockAll();
    }

    public String getReport() {
        String imageFile1 = "";
        String imageFile2 = "";
        try {
            XYSeries series1 = new XYSeries((Comparable)((Object)"Hubs"));
            for (Node node : this.hub_list) {
                int n_index = this.indicies.get(node);
                series1.add((double)n_index, this.hubs[n_index]);
            }
            XYSeries series2 = new XYSeries((Comparable)((Object)"Authority"));
            for (Node node : this.auth_list) {
                int n_index = this.indicies.get(node);
                series2.add((double)n_index, this.authority[n_index]);
            }
            XYSeriesCollection dataset = new XYSeriesCollection();
            dataset.addSeries(series1);
            JFreeChart chart = ChartFactory.createXYLineChart((String)"Hubs", (String)"Nodes", (String)"hubs", (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
            XYPlot plot = (XYPlot)chart.getPlot();
            XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
            renderer.setSeriesLinesVisible(0, true);
            renderer.setSeriesShapesVisible(0, false);
            renderer.setSeriesLinesVisible(1, false);
            renderer.setSeriesShapesVisible(1, true);
            renderer.setSeriesShape(1, (Shape)new Ellipse2D.Double(0.0, 0.0, 1.0, 1.0));
            plot.setBackgroundPaint((Paint)Color.WHITE);
            plot.setDomainGridlinePaint((Paint)Color.GRAY);
            plot.setRangeGridlinePaint((Paint)Color.GRAY);
            plot.setRenderer((XYItemRenderer)renderer);
            TempDirUtils.TempDir tempDir = TempDirUtils.createTempDir();
            ChartRenderingInfo info = new ChartRenderingInfo((EntityCollection)new StandardEntityCollection());
            String fileName = "hubs.png";
            File file1 = tempDir.createFile("hubs.png");
            imageFile1 = "<IMG SRC=\"file:" + file1.getAbsolutePath() + "\" " + "WIDTH=\"600\" HEIGHT=\"400\" BORDER=\"0\" USEMAP=\"#chart\"></IMG>";
            ChartUtilities.saveChartAsPNG((File)file1, (JFreeChart)chart, (int)600, (int)400, (ChartRenderingInfo)info);
            XYSeriesCollection dataset2 = new XYSeriesCollection();
            dataset2.addSeries(series2);
            JFreeChart chart2 = ChartFactory.createXYLineChart((String)"Authority", (String)"Nodes", (String)"Authority", (XYDataset)dataset2, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
            XYPlot plot2 = (XYPlot)chart2.getPlot();
            XYLineAndShapeRenderer renderer2 = new XYLineAndShapeRenderer();
            renderer2.setSeriesLinesVisible(0, true);
            renderer2.setSeriesShapesVisible(0, false);
            renderer2.setSeriesLinesVisible(1, false);
            renderer2.setSeriesShapesVisible(1, true);
            renderer2.setSeriesShape(1, (Shape)new Ellipse2D.Double(0.0, 0.0, 1.0, 1.0));
            plot2.setBackgroundPaint((Paint)Color.WHITE);
            plot2.setDomainGridlinePaint((Paint)Color.GRAY);
            plot2.setRangeGridlinePaint((Paint)Color.GRAY);
            plot2.setRenderer((XYItemRenderer)renderer);
            ChartRenderingInfo info2 = new ChartRenderingInfo((EntityCollection)new StandardEntityCollection());
            String fileName2 = "authority.png";
            File file2 = tempDir.createFile("authority.png");
            imageFile2 = "<IMG SRC=\"file:" + file2.getAbsolutePath() + "\" " + "WIDTH=\"600\" HEIGHT=\"400\" BORDER=\"0\" USEMAP=\"#chart\"></IMG>";
            ChartUtilities.saveChartAsPNG((File)file2, (JFreeChart)chart2, (int)600, (int)400, (ChartRenderingInfo)info2);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        String report = "<HTML> <BODY> <h1> HITS Metric Report </h1> <br> <hr><br><h2> Parameters: </h2>  <br> &#917; = " + this.epsilon + "<br> <h2> Results: </h2><br>" + imageFile1 + "<br>" + imageFile2 + "</BODY> </HTML>";
        return report;
    }

    public boolean cancel() {
        this.isCanceled = true;
        return true;
    }

    public void setProgressTicket(ProgressTicket progressTicket) {
        this.progress = progressTicket;
    }

    public void setEpsilon(double eps) {
        this.epsilon = eps;
    }

    public double getEpsilon() {
        return this.epsilon;
    }
}

