/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.statistics.plugin;

import java.text.DecimalFormat;
import org.gephi.data.attributes.api.AttributeColumn;
import org.gephi.data.attributes.api.AttributeModel;
import org.gephi.data.attributes.api.AttributeOrigin;
import org.gephi.data.attributes.api.AttributeRow;
import org.gephi.data.attributes.api.AttributeTable;
import org.gephi.data.attributes.api.AttributeType;
import org.gephi.graph.api.DirectedGraph;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.HierarchicalDirectedGraph;
import org.gephi.graph.api.HierarchicalGraph;
import org.gephi.graph.api.Node;
import org.gephi.statistics.spi.Statistics;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;

public class InOutDegree
implements Statistics,
LongTask {
    public static final String INDEGREE = "indegree";
    public static final String OUTDEGREE = "outdegree";
    public static final String DEGREE = "degree";
    private double avgInDegree;
    private double avgOutDegree;
    private boolean isCanceled;
    private ProgressTicket progress;
    private double avgDegree;

    public double getAverageDegree() {
        return this.avgDegree;
    }

    public void execute(GraphModel graphModel, AttributeModel attributeModel) {
        HierarchicalGraph graph = graphModel.getHierarchicalGraphVisible();
        this.execute(graph, attributeModel);
    }

    public void execute(HierarchicalGraph graph, AttributeModel attributeModel) {
        this.isCanceled = false;
        this.avgOutDegree = 0.0;
        this.avgInDegree = 0.0;
        AttributeTable nodeTable = attributeModel.getNodeTable();
        AttributeColumn inCol = nodeTable.getColumn(INDEGREE);
        AttributeColumn outCol = nodeTable.getColumn(OUTDEGREE);
        AttributeColumn degCol = nodeTable.getColumn(DEGREE);
        if (graph instanceof DirectedGraph) {
            if (inCol == null) {
                inCol = nodeTable.addColumn(INDEGREE, "In Degree", AttributeType.INT, AttributeOrigin.COMPUTED, (Object)0);
            }
            if (outCol == null) {
                outCol = nodeTable.addColumn(OUTDEGREE, "Out Degree", AttributeType.INT, AttributeOrigin.COMPUTED, (Object)0);
            }
        }
        if (degCol == null) {
            degCol = nodeTable.addColumn(DEGREE, "Degree", AttributeType.INT, AttributeOrigin.COMPUTED, (Object)0);
        }
        int i = 0;
        graph.readLock();
        Progress.start(this.progress, graph.getNodeCount());
        for (Node n : graph.getNodes()) {
            AttributeRow row = (AttributeRow)n.getNodeData().getAttributes();
            if (graph instanceof DirectedGraph) {
                HierarchicalDirectedGraph hdg = graph.getGraphModel().getHierarchicalDirectedGraph();
                row.setValue(inCol, (Object)hdg.getTotalInDegree(n));
                row.setValue(outCol, (Object)hdg.getTotalOutDegree(n));
                this.avgInDegree += (double)hdg.getTotalInDegree(n);
                this.avgOutDegree += (double)hdg.getTotalOutDegree(n);
            }
            row.setValue(degCol, (Object)graph.getTotalDegree(n));
            this.avgDegree += (double)graph.getTotalDegree(n);
            if (this.isCanceled) break;
            Progress.progress(this.progress, ++i);
        }
        this.avgInDegree /= (double)graph.getNodeCount();
        this.avgOutDegree /= (double)graph.getNodeCount();
        this.avgDegree /= (double)graph.getNodeCount();
        graph.readUnlockAll();
    }

    public String getReport() {
        DecimalFormat f = new DecimalFormat("#0.000");
        String report = "<HTML> <BODY> <h1>Degree Report </h1> <hr><br><br> <h2> Results: </h2>Average Degree: " + f.format(this.avgDegree) + (this.avgInDegree > 0.0 ? "<br >Average In Degree: " + f.format(this.avgInDegree) : "") + (this.avgOutDegree > 0.0 ? "<br >Average Out Degree: " + f.format(this.avgOutDegree) : "") + "</BODY></HTML>";
        return report;
    }

    public boolean cancel() {
        this.isCanceled = true;
        return true;
    }

    public void setProgressTicket(ProgressTicket progressTicket) {
        this.progress = progressTicket;
    }
}

