/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.statistics.plugin;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Random;
import java.util.Set;
import org.gephi.data.attributes.api.AttributeColumn;
import org.gephi.data.attributes.api.AttributeModel;
import org.gephi.data.attributes.api.AttributeOrigin;
import org.gephi.data.attributes.api.AttributeRow;
import org.gephi.data.attributes.api.AttributeTable;
import org.gephi.data.attributes.api.AttributeType;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.HierarchicalUndirectedGraph;
import org.gephi.graph.api.Node;
import org.gephi.statistics.spi.Statistics;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;

public class Modularity
implements Statistics,
LongTask {
    public static final String MODULARITY_CLASS = "modularity_class";
    private ProgressTicket progress;
    private boolean isCanceled;
    private CommunityStructure structure;
    private double modularity;
    private boolean isRandomized = false;

    public void setRandom(boolean isRandomized) {
        this.isRandomized = isRandomized;
    }

    public boolean getRandom() {
        return this.isRandomized;
    }

    public boolean cancel() {
        this.isCanceled = true;
        return true;
    }

    public void setProgressTicket(ProgressTicket progressTicket) {
        this.progress = progressTicket;
    }

    public void execute(GraphModel graphModel, AttributeModel attributeModel) {
        HierarchicalUndirectedGraph hgraph = graphModel.getHierarchicalUndirectedGraphVisible();
        this.execute(hgraph, attributeModel);
    }

    public void execute(HierarchicalUndirectedGraph hgraph, AttributeModel attributeModel) {
        this.isCanceled = false;
        Progress.start(this.progress);
        Random rand = new Random();
        hgraph.readLock();
        this.structure = new CommunityStructure(hgraph);
        if (this.isCanceled) {
            hgraph.readUnlockAll();
            return;
        }
        boolean someChange = true;
        while (someChange) {
            someChange = false;
            boolean localChange = true;
            while (localChange) {
                localChange = false;
                int start = 0;
                if (this.isRandomized) {
                    start = Math.abs(rand.nextInt()) % this.structure.N;
                }
                int step = 0;
                int i = start;
                while (step < this.structure.N) {
                    ++step;
                    double best = 0.0;
                    double current = this.q(i, this.structure.nodeCommunities[i]);
                    Community bestCommunity = null;
                    int smallest = Integer.MAX_VALUE;
                    Set<Community> iter = this.structure.nodeConnections[i].keySet();
                    for (Community com : iter) {
                        double qValue = this.q(i, com) - current;
                        if (qValue > best) {
                            best = qValue;
                            bestCommunity = com;
                            smallest = com.getMin();
                            continue;
                        }
                        if (qValue != best || com.getMin() >= smallest) continue;
                        best = qValue;
                        bestCommunity = com;
                        smallest = com.getMin();
                    }
                    if (this.structure.nodeCommunities[i] != bestCommunity && bestCommunity != null) {
                        this.structure.moveNodeTo(i, bestCommunity);
                        localChange = true;
                    }
                    if (this.isCanceled) {
                        hgraph.readUnlockAll();
                        return;
                    }
                    i = (i + 1) % this.structure.N;
                }
                boolean bl = someChange = localChange || someChange;
                if (!this.isCanceled) continue;
                hgraph.readUnlockAll();
                return;
            }
            if (!someChange) continue;
            this.structure.zoomOut();
        }
        int[] comStructure = new int[hgraph.getNodeCount()];
        int count = 0;
        double[] degreeCount = new double[this.structure.communities.size()];
        for (Community com : this.structure.communities) {
            for (Integer node : com.nodes) {
                Community hidden = this.structure.invMap.get(node);
                for (Integer nodeInt : hidden.nodes) {
                    comStructure[nodeInt.intValue()] = count;
                }
            }
            ++count;
        }
        for (Node node : hgraph.getNodes()) {
            int index = this.structure.map.get(node);
            int n = comStructure[index];
            degreeCount[n] = degreeCount[n] + (double)hgraph.getTotalDegree(node);
        }
        this.modularity = this.finalQ(comStructure, degreeCount, hgraph, attributeModel);
        hgraph.readUnlock();
    }

    private double finalQ(int[] struct, double[] degrees, HierarchicalUndirectedGraph hgraph, AttributeModel attributeModel) {
        AttributeTable nodeTable = attributeModel.getNodeTable();
        AttributeColumn modCol = nodeTable.getColumn(MODULARITY_CLASS);
        if (modCol == null) {
            modCol = nodeTable.addColumn(MODULARITY_CLASS, "Modularity Class", AttributeType.INT, AttributeOrigin.COMPUTED, (Object)new Integer(0));
        }
        double res = 0.0;
        double[] internal = new double[degrees.length];
        for (Node n : hgraph.getNodes()) {
            int n_index = this.structure.map.get(n);
            AttributeRow row = (AttributeRow)n.getNodeData().getAttributes();
            row.setValue(modCol, (Object)struct[n_index]);
            for (Node neighbor : hgraph.getNeighbors(n)) {
                int neigh_index;
                if (n == neighbor || struct[neigh_index = this.structure.map.get(neighbor).intValue()] != struct[n_index]) continue;
                int n2 = struct[neigh_index];
                internal[n2] = internal[n2] + 1.0;
            }
        }
        for (int i = 0; i < degrees.length; ++i) {
            int n = i;
            internal[n] = internal[n] / 2.0;
            res += internal[i] / (double)hgraph.getTotalEdgeCount() - Math.pow(degrees[i] / (double)(2 * hgraph.getTotalEdgeCount()), 2.0);
        }
        return res;
    }

    public double getModularity() {
        return this.modularity;
    }

    public String getReport() {
        String report = "<HTML> <BODY> <h1>Modularity Report </h1> <hr><h2> Parameters: </h2>Randomize:  " + (this.isRandomized ? "On" : "Off") + "<br>" + "<br> <h2> Results: </h2>" + "Modularity: " + this.modularity + "<br>" + "Number of Communities: " + this.structure.communities.size() + "</BODY></HTML>";
        return report;
    }

    private double q(int node, Community community) {
        Integer edgesToInt = this.structure.nodeConnections[node].get(community);
        double edgesTo = 0.0;
        if (edgesToInt != null) {
            edgesTo = edgesToInt.doubleValue();
        }
        double weightSum = community.weightSum;
        double nodeWeight = this.structure.weights[node];
        double qValue = edgesTo - nodeWeight * weightSum / (2.0 * this.structure.graphWeightSum);
        if (this.structure.nodeCommunities[node] == community && this.structure.nodeCommunities[node].size() > 1) {
            qValue = edgesTo - nodeWeight * (weightSum - nodeWeight) / (2.0 * this.structure.graphWeightSum);
        }
        return qValue;
    }

    class Community {
        double weightSum;
        CommunityStructure structure;
        LinkedList<Integer> nodes;
        HashMap<Community, Integer> connections;
        Integer min;

        public int size() {
            return this.nodes.size();
        }

        public Community(Community com) {
            this.structure = com.structure;
            this.connections = new HashMap();
            this.nodes = new LinkedList();
            this.min = Integer.MAX_VALUE;
        }

        public Community(CommunityStructure structure) {
            this.structure = structure;
            this.connections = new HashMap();
            this.nodes = new LinkedList();
        }

        public void seed(int node) {
            this.nodes.add(node);
            this.weightSum += this.structure.weights[node];
            this.min = node;
        }

        public boolean add(int node) {
            this.nodes.addLast(new Integer(node));
            this.weightSum += this.structure.weights[node];
            if (!Modularity.this.isRandomized) {
                this.min = Math.min(node, this.min);
            }
            return true;
        }

        public boolean remove(int node) {
            boolean result = this.nodes.remove(new Integer(node));
            this.weightSum -= this.structure.weights[node];
            if (this.nodes.size() == 0) {
                this.structure.communities.remove(this);
            }
            if (!Modularity.this.isRandomized && node == this.min) {
                this.min = Integer.MAX_VALUE;
                for (Integer other : this.nodes) {
                    this.min = Math.min(other, this.min);
                }
            }
            return result;
        }

        public int getMin() {
            return this.min;
        }
    }

    class CommunityStructure {
        HashMap<Community, Integer>[] nodeConnections;
        HashMap<Node, Integer> map;
        Community[] nodeCommunities;
        HierarchicalUndirectedGraph graph;
        double[] weights;
        double graphWeightSum;
        LinkedList<ModEdge>[] topology;
        LinkedList<Community> communities;
        int N;
        HashMap<Integer, Community> invMap;

        CommunityStructure(HierarchicalUndirectedGraph hgraph) {
            this.graph = hgraph;
            this.N = hgraph.getNodeCount();
            this.invMap = new HashMap();
            this.nodeConnections = new HashMap[this.N];
            this.nodeCommunities = new Community[this.N];
            this.map = new HashMap();
            this.topology = new LinkedList[this.N];
            this.communities = new LinkedList();
            int index = 0;
            this.weights = new double[this.N];
            for (Node node : hgraph.getNodes()) {
                this.map.put(node, index);
                this.nodeCommunities[index] = new Community(this);
                this.nodeConnections[index] = new HashMap();
                this.weights[index] = hgraph.getTotalDegree(node);
                this.nodeCommunities[index].seed(index);
                Community hidden = new Community(Modularity.this.structure);
                hidden.nodes.add(index);
                this.invMap.put(index, hidden);
                this.communities.add(this.nodeCommunities[index]);
                ++index;
                if (!Modularity.this.isCanceled) continue;
                return;
            }
            for (Node node : hgraph.getNodes()) {
                int node_index = this.map.get(node);
                this.topology[node_index] = new LinkedList();
                for (Node neighbor : hgraph.getNeighbors(node)) {
                    if (node == neighbor) continue;
                    int neighbor_index = this.map.get(neighbor);
                    ModEdge me = new ModEdge(node_index, neighbor_index, 1);
                    this.topology[node_index].add(me);
                    Community adjCom = this.nodeCommunities[neighbor_index];
                    this.nodeConnections[node_index].put(adjCom, 1);
                    this.nodeCommunities[node_index].connections.put(adjCom, 1);
                    this.nodeConnections[neighbor_index].put(this.nodeCommunities[node_index], 1);
                    this.nodeCommunities[neighbor_index].connections.put(this.nodeCommunities[node_index], 1);
                    this.graphWeightSum += 1.0;
                }
                if (!Modularity.this.isCanceled) continue;
                return;
            }
            this.graphWeightSum /= 2.0;
        }

        private void addNodeTo(int node, Community to) {
            to.add(new Integer(node));
            this.nodeCommunities[node] = to;
            for (ModEdge e : this.topology[node]) {
                int neighbor = e.target;
                Integer neighEdgesTo = this.nodeConnections[neighbor].get(to);
                if (neighEdgesTo == null) {
                    this.nodeConnections[neighbor].put(to, e.weight);
                } else {
                    this.nodeConnections[neighbor].put(to, neighEdgesTo + e.weight);
                }
                Community adjCom = this.nodeCommunities[neighbor];
                Integer oEdgesto = adjCom.connections.get(to);
                if (oEdgesto == null) {
                    adjCom.connections.put(to, e.weight);
                } else {
                    adjCom.connections.put(to, oEdgesto + e.weight);
                }
                Integer nodeEdgesTo = this.nodeConnections[node].get(adjCom);
                if (nodeEdgesTo == null) {
                    this.nodeConnections[node].put(adjCom, e.weight);
                } else {
                    this.nodeConnections[node].put(adjCom, nodeEdgesTo + e.weight);
                }
                if (to == adjCom) continue;
                Integer comEdgesto = to.connections.get(adjCom);
                if (comEdgesto == null) {
                    to.connections.put(adjCom, e.weight);
                    continue;
                }
                to.connections.put(adjCom, comEdgesto + e.weight);
            }
        }

        private void removeNodeFrom(int node, Community from) {
            Community community = this.nodeCommunities[node];
            for (ModEdge e : this.topology[node]) {
                Integer nodeEgesTo;
                int neighbor = e.target;
                Integer edgesTo = this.nodeConnections[neighbor].get(community);
                if (edgesTo - e.weight == 0) {
                    this.nodeConnections[neighbor].remove(community);
                } else {
                    this.nodeConnections[neighbor].put(community, edgesTo - e.weight);
                }
                Community adjCom = this.nodeCommunities[neighbor];
                Integer oEdgesto = adjCom.connections.get(community);
                if (oEdgesto - e.weight == 0) {
                    adjCom.connections.remove(community);
                } else {
                    adjCom.connections.put(community, oEdgesto - e.weight);
                }
                if (node == neighbor) continue;
                if (adjCom != community) {
                    Integer comEdgesto = community.connections.get(adjCom);
                    if (comEdgesto - e.weight == 0) {
                        community.connections.remove(adjCom);
                    } else {
                        community.connections.put(adjCom, comEdgesto - e.weight);
                    }
                }
                if ((nodeEgesTo = this.nodeConnections[node].get(adjCom)) - e.weight == 0) {
                    this.nodeConnections[node].remove(adjCom);
                    continue;
                }
                this.nodeConnections[node].put(adjCom, nodeEgesTo - e.weight);
            }
            from.remove(new Integer(node));
        }

        private void moveNodeTo(int node, Community to) {
            Community from = this.nodeCommunities[node];
            this.removeNodeFrom(node, from);
            this.addNodeTo(node, to);
        }

        private void zoomOut() {
            Community com;
            int i;
            int M = this.communities.size();
            LinkedList[] newTopology = new LinkedList[M];
            int index = 0;
            this.nodeCommunities = new Community[M];
            this.nodeConnections = new HashMap[M];
            HashMap<Integer, Community> newInvMap = new HashMap<Integer, Community>();
            for (i = 0; i < this.communities.size(); ++i) {
                com = this.communities.get(i);
                this.nodeConnections[index] = new HashMap();
                newTopology[index] = new LinkedList();
                this.nodeCommunities[index] = new Community(com);
                Set<Community> iter = com.connections.keySet();
                double weightSum = 0.0;
                Community hidden = new Community(Modularity.this.structure);
                for (Integer nodeInt : com.nodes) {
                    Community oldHidden = this.invMap.get(nodeInt);
                    hidden.nodes.addAll(oldHidden.nodes);
                }
                newInvMap.put(index, hidden);
                for (Community adjCom : iter) {
                    int target = this.communities.indexOf(adjCom);
                    int weight = com.connections.get(adjCom);
                    weightSum += (double)weight;
                    ModEdge e = new ModEdge(index, target, weight);
                    newTopology[index].add(e);
                }
                this.weights[index] = weightSum;
                this.nodeCommunities[index].seed(index);
                ++index;
            }
            this.communities.clear();
            for (i = 0; i < M; ++i) {
                com = this.nodeCommunities[i];
                this.communities.add(com);
                for (ModEdge e : newTopology[i]) {
                    this.nodeConnections[i].put(this.nodeCommunities[e.target], e.weight);
                    com.connections.put(this.nodeCommunities[e.target], e.weight);
                }
            }
            this.N = M;
            this.topology = newTopology;
            this.invMap = newInvMap;
        }
    }

    class ModEdge {
        int source;
        int target;
        int weight;

        public ModEdge(int s, int t, int w) {
            this.source = s;
            this.target = t;
            this.weight = w;
        }
    }
}

