/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.statistics.plugin;

import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.gephi.data.attributes.api.AttributeColumn;
import org.gephi.data.attributes.api.AttributeModel;
import org.gephi.data.attributes.api.AttributeOrigin;
import org.gephi.data.attributes.api.AttributeRow;
import org.gephi.data.attributes.api.AttributeTable;
import org.gephi.data.attributes.api.AttributeType;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.EdgeIterable;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.HierarchicalDirectedGraph;
import org.gephi.graph.api.HierarchicalGraph;
import org.gephi.graph.api.HierarchicalUndirectedGraph;
import org.gephi.graph.api.Node;
import org.gephi.statistics.spi.Statistics;
import org.gephi.utils.TempDirUtils;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.StandardEntityCollection;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.openide.util.Lookup;

public class PageRank
implements Statistics,
LongTask {
    public static final String PAGERANK = "pageranks";
    private ProgressTicket progress;
    private boolean isCanceled;
    private double epsilon = 0.001;
    private double probability = 0.85;
    private double[] pageranks;
    private boolean isDirected;

    public PageRank() {
        GraphController graphController = (GraphController)Lookup.getDefault().lookup(GraphController.class);
        if (graphController != null && graphController.getModel() != null) {
            this.isDirected = graphController.getModel().isDirected();
        }
    }

    public void setDirected(boolean isDirected) {
        this.isDirected = isDirected;
    }

    public boolean getDirected() {
        return this.isDirected;
    }

    public void execute(GraphModel graphModel, AttributeModel attributeModel) {
        HierarchicalGraph graph = this.isDirected ? graphModel.getHierarchicalDirectedGraphVisible() : graphModel.getHierarchicalUndirectedGraphVisible();
        this.execute(graph, attributeModel);
    }

    public void execute(HierarchicalGraph hgraph, AttributeModel attributeModel) {
        boolean done;
        this.isCanceled = false;
        hgraph.readLock();
        int N = hgraph.getNodeCount();
        this.pageranks = new double[N];
        double[] temp = new double[N];
        HashMap<Node, Integer> indicies = new HashMap<Node, Integer>();
        int index = 0;
        Progress.start(this.progress);
        for (Node s : hgraph.getNodes()) {
            indicies.put(s, index);
            this.pageranks[index] = 1.0f / (float)N;
            ++index;
        }
        do {
            double r = 0.0;
            for (Node s : hgraph.getNodes()) {
                boolean out;
                int s_index = (Integer)indicies.get(s);
                if (this.isDirected) {
                    out = ((HierarchicalDirectedGraph)hgraph).getTotalOutDegree(s) > 0;
                } else {
                    boolean bl = out = hgraph.getTotalDegree(s) > 0;
                }
                r = out ? (r += (1.0 - this.probability) * (this.pageranks[s_index] / (double)N)) : (r += this.pageranks[s_index] / (double)N);
                if (!this.isCanceled) continue;
                hgraph.readUnlockAll();
                return;
            }
            done = true;
            for (Node s : hgraph.getNodes()) {
                int s_index = (Integer)indicies.get(s);
                temp[s_index] = r;
                EdgeIterable eIter = this.isDirected ? ((HierarchicalDirectedGraph)hgraph).getInEdgesAndMetaInEdges(s) : ((HierarchicalUndirectedGraph)hgraph).getEdgesAndMetaEdges(s);
                for (Edge edge : eIter) {
                    Node neighbor = hgraph.getOpposite(s, edge);
                    int neigh_index = (Integer)indicies.get(neighbor);
                    int normalize = this.isDirected ? ((HierarchicalDirectedGraph)hgraph).getTotalOutDegree(neighbor) : ((HierarchicalUndirectedGraph)hgraph).getTotalDegree(neighbor);
                    int n = s_index;
                    temp[n] = temp[n] + this.probability * (this.pageranks[neigh_index] / (double)normalize);
                }
                if ((temp[s_index] - this.pageranks[s_index]) / this.pageranks[s_index] >= this.epsilon) {
                    done = false;
                }
                if (!this.isCanceled) continue;
                hgraph.readUnlockAll();
                return;
            }
            this.pageranks = temp;
            temp = new double[N];
        } while (!done && !this.isCanceled);
        AttributeTable nodeTable = attributeModel.getNodeTable();
        AttributeColumn pangeRanksCol = nodeTable.getColumn(PAGERANK);
        if (pangeRanksCol == null) {
            pangeRanksCol = nodeTable.addColumn(PAGERANK, "PageRank", AttributeType.DOUBLE, AttributeOrigin.COMPUTED, (Object)new Double(0.0));
        }
        for (Node s : hgraph.getNodes()) {
            int s_index = (Integer)indicies.get(s);
            AttributeRow row = (AttributeRow)s.getNodeData().getAttributes();
            row.setValue(pangeRanksCol, (Object)this.pageranks[s_index]);
        }
        hgraph.readUnlockAll();
    }

    public String getReport() {
        XYSeries series = new XYSeries((Comparable)((Object)"Series 2"));
        for (int i = 0; i < this.pageranks.length; ++i) {
            series.add((double)i, this.pageranks[i]);
        }
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(series);
        JFreeChart chart = ChartFactory.createXYLineChart((String)"PageRanks", (String)"Nodes", (String)"PageRank", (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        XYPlot plot = (XYPlot)chart.getPlot();
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
        renderer.setSeriesLinesVisible(0, true);
        renderer.setSeriesShapesVisible(0, false);
        renderer.setSeriesLinesVisible(1, false);
        renderer.setSeriesShapesVisible(1, true);
        renderer.setSeriesShape(1, (Shape)new Ellipse2D.Double(0.0, 0.0, 1.0, 1.0));
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setDomainGridlinePaint((Paint)Color.GRAY);
        plot.setRangeGridlinePaint((Paint)Color.GRAY);
        plot.setRenderer((XYItemRenderer)renderer);
        String imageFile = "";
        try {
            ChartRenderingInfo info = new ChartRenderingInfo((EntityCollection)new StandardEntityCollection());
            TempDirUtils.TempDir tempDir = TempDirUtils.createTempDir();
            String fileName = "pageranks.png";
            File file1 = tempDir.createFile(fileName);
            imageFile = "<IMG SRC=\"file:" + file1.getAbsolutePath() + "\" " + "WIDTH=\"600\" HEIGHT=\"400\" BORDER=\"0\" USEMAP=\"#chart\"></IMG>";
            ChartUtilities.saveChartAsPNG((File)file1, (JFreeChart)chart, (int)600, (int)400, (ChartRenderingInfo)info);
        }
        catch (IOException e) {
            System.out.println(e.toString());
        }
        String report = "<HTML> <BODY> <h1>PageRank Report </h1> <hr> <br><h2> Parameters: </h2>Epsilon = " + this.epsilon + "<br>" + "Probability = " + this.probability + "<br> <h2> Results: </h2>" + imageFile + "</BODY></HTML>";
        return report;
    }

    public boolean cancel() {
        this.isCanceled = true;
        return true;
    }

    public void setProgressTicket(ProgressTicket progressTicket) {
        this.progress = progressTicket;
    }

    public void setProbability(double prob) {
        this.probability = prob;
    }

    public void setEpsilon(double eps) {
        this.epsilon = eps;
    }

    public double getProbability() {
        return this.probability;
    }

    public double getEpsilon() {
        return this.epsilon;
    }
}

