/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatisticsUtils {
    public static BigDecimal average(Number[] numbers) {
        BigDecimal result;
        if (numbers == null || numbers.length == 0) {
            return null;
        }
        BigDecimal sum = new BigDecimal(0);
        int numbersCount = 0;
        for (Number number : numbers) {
            if (number == null) continue;
            sum = sum.add(new BigDecimal(number.toString()));
            ++numbersCount;
        }
        try {
            result = sum.divide(new BigDecimal(numbersCount));
        }
        catch (ArithmeticException ex) {
            result = sum.divide(new BigDecimal(numbersCount), 10, RoundingMode.HALF_EVEN);
        }
        return result;
    }

    public static BigDecimal average(Collection<Number> numbers) {
        return StatisticsUtils.average(numbers.toArray(new Number[0]));
    }

    public static BigDecimal median(Number[] numbers) {
        if (numbers == null || numbers.length == 0) {
            return null;
        }
        BigDecimal[] bigDecimalNumbers = StatisticsUtils.numbersArrayToSortedBigDecimalArray(numbers);
        return StatisticsUtils.median(bigDecimalNumbers);
    }

    public static BigDecimal median(Collection<Number> numbers) {
        return StatisticsUtils.median(numbers.toArray(new Number[0]));
    }

    public static BigDecimal quartile1(Number[] numbers) {
        if (numbers == null || numbers.length == 0) {
            return null;
        }
        BigDecimal[] bigDecimalNumbers = StatisticsUtils.numbersArrayToSortedBigDecimalArray(numbers);
        return StatisticsUtils.quartile1(bigDecimalNumbers);
    }

    public static BigDecimal quartile1(Collection<Number> numbers) {
        return StatisticsUtils.quartile1(numbers.toArray(new Number[0]));
    }

    public static BigDecimal quartile3(Number[] numbers) {
        if (numbers == null || numbers.length == 0) {
            return null;
        }
        BigDecimal[] bigDecimalNumbers = StatisticsUtils.numbersArrayToSortedBigDecimalArray(numbers);
        return StatisticsUtils.quartile3(bigDecimalNumbers);
    }

    public static BigDecimal quartile3(Collection<Number> numbers) {
        return StatisticsUtils.quartile3(numbers.toArray(new Number[0]));
    }

    public static BigDecimal sum(Number[] numbers) {
        if (numbers == null || numbers.length == 0) {
            return null;
        }
        BigDecimal sum = new BigDecimal(0);
        for (Number number : numbers) {
            if (number == null) continue;
            sum = sum.add(new BigDecimal(number.toString()));
        }
        return sum;
    }

    public static BigDecimal sum(Collection<Number> numbers) {
        return StatisticsUtils.sum(numbers.toArray(new Number[0]));
    }

    public static BigDecimal minValue(Number[] numbers) {
        if (numbers == null || numbers.length == 0) {
            return null;
        }
        BigDecimal[] bigDecimalNumbers = StatisticsUtils.numbersArrayToSortedBigDecimalArray(numbers);
        return bigDecimalNumbers[0];
    }

    public static BigDecimal minValue(Collection<Number> numbers) {
        return StatisticsUtils.minValue(numbers.toArray(new Number[0]));
    }

    public static BigDecimal maxValue(Number[] numbers) {
        if (numbers == null || numbers.length == 0) {
            return null;
        }
        BigDecimal[] bigDecimalNumbers = StatisticsUtils.numbersArrayToSortedBigDecimalArray(numbers);
        return bigDecimalNumbers[bigDecimalNumbers.length - 1];
    }

    public static BigDecimal maxValue(Collection<Number> numbers) {
        return StatisticsUtils.maxValue(numbers.toArray(new Number[0]));
    }

    public static BigDecimal[] getAllStatistics(Number[] numbers) {
        BigDecimal[] statistics;
        if (numbers == null || numbers.length == 0) {
            return null;
        }
        BigDecimal[] bigDecimalNumbers = StatisticsUtils.numbersArrayToSortedBigDecimalArray(numbers);
        BigDecimal sum = StatisticsUtils.sum(bigDecimalNumbers);
        statistics = new BigDecimal[]{StatisticsUtils.average(sum, new BigDecimal(bigDecimalNumbers.length)), StatisticsUtils.quartile1(bigDecimalNumbers), StatisticsUtils.median(bigDecimalNumbers), StatisticsUtils.quartile3(bigDecimalNumbers), statistics[3].subtract(statistics[1]), sum, StatisticsUtils.minValue(bigDecimalNumbers), StatisticsUtils.maxValue(bigDecimalNumbers)};
        return statistics;
    }

    public static BigDecimal[] getAllStatistics(Collection<Number> numbers) {
        return StatisticsUtils.getAllStatistics(numbers.toArray(new Number[0]));
    }

    public static BigDecimal[] numbersArrayToSortedBigDecimalArray(Number[] numbers) {
        if (numbers == null) {
            return null;
        }
        Object[] result = new BigDecimal[numbers.length];
        for (int i = 0; i < result.length; ++i) {
            Number number = numbers[i];
            if (number == null) continue;
            result[i] = new BigDecimal(number.toString());
        }
        Arrays.sort(result);
        return result;
    }

    private static BigDecimal average(BigDecimal sum, BigDecimal numbersCount) {
        BigDecimal result;
        try {
            result = sum.divide(numbersCount);
        }
        catch (ArithmeticException ex) {
            result = sum.divide(numbersCount, 10, RoundingMode.HALF_EVEN);
        }
        return result;
    }

    private static BigDecimal median(BigDecimal[] bigDecimalNumbers) {
        return StatisticsUtils.median(bigDecimalNumbers, 0, bigDecimalNumbers.length);
    }

    private static BigDecimal median(BigDecimal[] bigDecimalNumbers, int start, int end) {
        int size = end - start;
        if (size % 2 == 1) {
            return bigDecimalNumbers[start + (size + 1) / 2 - 1];
        }
        BigDecimal result = bigDecimalNumbers[start + size / 2 - 1];
        result = result.add(bigDecimalNumbers[start + size / 2]);
        return result.divide(BigDecimal.valueOf(2L));
    }

    private static BigDecimal quartile1(BigDecimal[] bigDecimalNumbers) {
        int size = bigDecimalNumbers.length;
        if (size % 2 == 1) {
            if (size > 1) {
                return StatisticsUtils.median(bigDecimalNumbers, 0, size / 2 + 1);
            }
            return StatisticsUtils.median(bigDecimalNumbers, 0, 1);
        }
        return StatisticsUtils.median(bigDecimalNumbers, 0, size / 2);
    }

    private static BigDecimal quartile3(BigDecimal[] bigDecimalNumbers) {
        int size = bigDecimalNumbers.length;
        if (size % 2 == 1) {
            if (size > 1) {
                return StatisticsUtils.median(bigDecimalNumbers, size / 2, size);
            }
            return StatisticsUtils.median(bigDecimalNumbers, 0, 1);
        }
        return StatisticsUtils.median(bigDecimalNumbers, size / 2, size);
    }

    private static BigDecimal sum(BigDecimal[] bigDecimalNumbers) {
        BigDecimal sum = new BigDecimal(0);
        for (BigDecimal number : bigDecimalNumbers) {
            if (number == null) continue;
            sum = sum.add(number);
        }
        return sum;
    }

    private static BigDecimal minValue(BigDecimal[] bigDecimalNumbers) {
        return bigDecimalNumbers[0];
    }

    private static BigDecimal maxValue(BigDecimal[] bigDecimalNumbers) {
        return bigDecimalNumbers[bigDecimalNumbers.length - 1];
    }
}

