/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.utils.longtask.api;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gephi.utils.longtask.api.LongTaskErrorHandler;
import org.gephi.utils.longtask.api.LongTaskListener;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.ProgressTicket;
import org.gephi.utils.progress.ProgressTicketProvider;
import org.openide.util.Cancellable;
import org.openide.util.Lookup;

public final class LongTaskExecutor {
    private final boolean inBackground;
    private boolean interruptCancel;
    private final long interruptDelay;
    private final String name;
    private RunningLongTask runningTask;
    private ExecutorService executor;
    private Timer cancelTimer;
    private LongTaskListener listener;
    private LongTaskErrorHandler errorHandler;
    private LongTaskErrorHandler defaultErrorHandler;

    public LongTaskExecutor(boolean doInBackground, String name, int interruptDelay) {
        this.inBackground = doInBackground;
        this.name = name;
        this.interruptCancel = true;
        this.interruptDelay = interruptDelay * 1000;
    }

    public LongTaskExecutor(boolean doInBackground, String name) {
        this(doInBackground, name, 0);
        this.interruptCancel = false;
    }

    public LongTaskExecutor(boolean doInBackground) {
        this(doInBackground, "LongTaskExecutor");
    }

    public void execute(LongTask task, Runnable runnable, String taskName, LongTaskErrorHandler errorHandler) {
        if (runnable == null || taskName == null) {
            throw new NullPointerException();
        }
        if (this.runningTask != null) {
            throw new IllegalStateException("A task is still executing");
        }
        if (this.executor == null) {
            this.executor = new ThreadPoolExecutor(0, 1, 15L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory());
        }
        if (errorHandler != null) {
            this.errorHandler = errorHandler;
        }
        this.runningTask = new RunningLongTask(task, runnable, taskName);
        if (this.inBackground) {
            this.runningTask.future = this.executor.submit(this.runningTask);
        } else {
            this.runningTask.run();
        }
    }

    public void execute(LongTask task, Runnable runnable) {
        this.execute(task, runnable, "", null);
    }

    public synchronized void cancel() {
        if (this.runningTask != null && this.runningTask.isCancellable()) {
            if (this.interruptCancel) {
                if (!this.runningTask.cancel()) {
                    this.cancelTimer = new Timer(this.name + "_cancelTimer");
                    this.cancelTimer.schedule((TimerTask)new InterruptTimerTask(), this.interruptDelay);
                }
            } else {
                this.runningTask.cancel();
            }
        }
    }

    public boolean isRunning() {
        return this.runningTask != null;
    }

    public void setLongTaskListener(LongTaskListener listener) {
        this.listener = listener;
    }

    public void setDefaultErrorHandler(LongTaskErrorHandler errorHandler) {
        if (errorHandler != null) {
            this.defaultErrorHandler = errorHandler;
        }
    }

    private synchronized void finished() {
        if (this.cancelTimer != null) {
            this.cancelTimer.cancel();
        }
        LongTask task = this.runningTask.task;
        this.runningTask = null;
        this.errorHandler = null;
        if (this.listener != null) {
            this.listener.taskFinished(task);
        }
    }

    private class InterruptTimerTask
    extends TimerTask {
        private InterruptTimerTask() {
        }

        public void run() {
            if (LongTaskExecutor.this.runningTask != null) {
                LongTaskExecutor.this.executor.shutdownNow();
            }
        }
    }

    private class NamedThreadFactory
    implements ThreadFactory {
        private NamedThreadFactory() {
        }

        public Thread newThread(Runnable r) {
            return new Thread(r, LongTaskExecutor.this.name);
        }
    }

    private class RunningLongTask
    implements Runnable {
        private final LongTask task;
        private final Runnable runnable;
        private Future future;
        private ProgressTicket progress;

        public RunningLongTask(LongTask task, Runnable runnable, String taskName) {
            this.task = task;
            this.runnable = runnable;
            ProgressTicketProvider progressProvider = (ProgressTicketProvider)Lookup.getDefault().lookup(ProgressTicketProvider.class);
            if (progressProvider != null) {
                this.progress = progressProvider.createTicket(taskName, new Cancellable(){

                    public boolean cancel() {
                        LongTaskExecutor.this.cancel();
                        return true;
                    }
                });
                if (task != null) {
                    task.setProgressTicket(this.progress);
                }
            }
        }

        public void run() {
            try {
                this.runnable.run();
            }
            catch (Exception e) {
                LongTaskErrorHandler err = LongTaskExecutor.this.errorHandler;
                LongTaskExecutor.this.finished();
                if (this.progress != null) {
                    this.progress.finish();
                }
                if (err != null) {
                    err.fatalError(e);
                }
                if (LongTaskExecutor.this.defaultErrorHandler != null) {
                    LongTaskExecutor.this.defaultErrorHandler.fatalError(e);
                }
                Logger.getLogger("").log(Level.SEVERE, "", e);
            }
            LongTaskExecutor.this.finished();
            if (this.progress != null) {
                this.progress.finish();
            }
        }

        public boolean cancel() {
            if (this.task != null) {
                return this.task.cancel();
            }
            return false;
        }

        public boolean isCancellable() {
            if (LongTaskExecutor.this.inBackground) {
                return !this.future.isCancelled();
            }
            return true;
        }
    }
}

