/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.visualization.impl;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import org.gephi.graph.api.TextData;

public class TextDataImpl
implements TextData {
    TextLine line = new TextLine();
    TextLine[] wrappedLines;
    float r = -1.0f;
    float g;
    float b;
    float a = 1.0f;
    float size = 1.0f;
    float sizeFactor = 1.0f;
    boolean visible = true;

    public TextLine getLine() {
        return this.line;
    }

    public void setWrappedLines(TextLine[] lines) {
        this.wrappedLines = lines;
    }

    public void setText(String line) {
        this.line = new TextLine(line, this.line.bounds);
    }

    public boolean hasCustomColor() {
        return this.r > 0.0f;
    }

    public void setSize(float size) {
        this.size = size;
    }

    public void setSizeFactor(float sizeFactor) {
        this.sizeFactor = sizeFactor * this.size;
    }

    public void setColor(float r, float g, float b, float alpha) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = alpha;
    }

    public void setColor(Color color) {
        if (color == null) {
            this.r = -1.0f;
        } else {
            this.setColor((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)color.getAlpha() / 255.0f);
        }
    }

    public float getWidth() {
        Rectangle2D rec = this.line.bounds;
        if (rec != null) {
            return (float)rec.getWidth() * this.sizeFactor;
        }
        return 0.0f;
    }

    public float getHeight() {
        Rectangle2D rec = this.line.bounds;
        if (rec != null) {
            return (float)rec.getHeight() * this.sizeFactor;
        }
        return 0.0f;
    }

    public String getText() {
        return this.line.text;
    }

    public float getSizeFactor() {
        return this.sizeFactor;
    }

    public float getSize() {
        return this.size;
    }

    public float getR() {
        return this.r;
    }

    public float getG() {
        return this.g;
    }

    public float getB() {
        return this.b;
    }

    public float getAlpha() {
        return this.a;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public static class TextLine {
        String text = "";
        Rectangle2D bounds;

        public TextLine() {
        }

        public TextLine(String text) {
            this.text = text;
        }

        public TextLine(String text, Rectangle2D bounds) {
            this.text = text;
            this.bounds = bounds;
        }

        public String getText() {
            return this.text;
        }

        public void setBounds(Rectangle2D bounds) {
            this.bounds = bounds;
        }
    }
}

