import platform

class BaseConsoleSize(object):

        @property
        def size(self):
            return self._get_size()
        
        @property
        def width(self): return self._get_size()[0]
        
        @property
        def height(self): return self._get_size()[1]
    
if platform.system() == 'Windows':
    from ctypes import windll, create_string_buffer
    class WindowsConsoleSize(BaseConsoleSize):
        
        def _get_size(self):

            # stdin handle is -10
            # stdout handle is -11
            # stderr handle is -12

            h = windll.kernel32.GetStdHandle(-12)
            csbi = create_string_buffer(22)
            res = windll.kernel32.GetConsoleScreenBufferInfo(h, csbi)

            if res:
                import struct
                (bufx, bufy, curx, cury, wattr,
                 left, top, right, bottom, maxx, maxy) = struct.unpack("hhhhHhhhhhh", csbi.raw)
                sizex = right - left + 1
                sizey = bottom - top + 1
            else:
                sizex, sizey = 80, 25 # can't determine actual size - return default values

            return (sizex, sizey)
    ConsoleSize = WindowsConsoleSize()
	
else:
    import os
    class OtherConsoleSize(BaseConsoleSize):
        
        def _get_size(self):
            (sizey, sizex) = os.popen('stty size', 'r').read().split()
            return (sizex, sizey)
    ConsoleSize = OtherConsoleSize()
